/***************************************************************
 *                    simula.plus@cemes.fr                     *
 *	             GNU/linux version 3.4.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2007,2008,2009,2012 COLLARD Christophe
 * copyright © 2007,2008,2009,2012 Centre National de la Recherche Scientifique
 * copyright © 2007,2008,2009 Arts et Métiers ParisTech
 * copyright © 2007 Université de Valenciennes et du Hainaut-Cambrésis
 * copyright © 2007,2008,2009 Laboratoire de Physique et Mécanique des Matériaux (LPMM - CNRS)
 * copyright © 2007 Laboratoire de Mathématiques et ses Applications de Valenciennes (LAMAV)
 * copyright © 2012 Centre d'Elaboration de Matériaux et d'Etudes Structurales (CEMES - CNRS)
 ***************************************************************/

/*
    abaqus conversion tools-test belongs to Mathematical Object Libraries (MOL++)
    MOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type conversion tools-test
#endif

#ifndef __ABAQUS_conversion_tools_test_hpp
#define __ABAQUS_conversion_tools_test_hpp


#ifndef __iostream
#include <iostream>
#endif

#ifndef __stdio_h
#include <stdio.h>
#endif

#ifndef __stdlib_h
#include <stdlib.h>
#endif

#ifndef __colors_hpp
#include "colors.hpp"
#endif

#ifndef __vectors_hpp
#include "MOL++/vectors.hpp"
#endif

#ifndef __matrix_hpp
#include "MOL++/matrix.hpp"
#endif

#ifndef __symtensors2_hpp
#include "MOL++/symtensors2.hpp"
#endif

#ifndef __tensors4_hpp
#include "MOL++/tensors4.hpp"
#endif

#ifndef __symtensors2_hpp
#include "MOL++/symtensors2.hpp"
#endif

#ifndef __ABAQUS_conversion_tools_hpp
#include "MOL++/abaqus conversion tools.hpp"
#endif

#ifndef __affiche_hpp
#include "tests/affiche.hpp"
#endif

using namespace abaqus;


//===========================================
int test_abaqus_conversion_tools (int detail)
//===========================================
{
  int result=1;

  long double * v;
  symtensor2<long double> stress(3,false), strain(3,false);
  v = new long double [6];
  for (int i=1; i<=3; i++)
    v[i-1] = stress(i,i) = strain(i,i) = 2.3*i;
  v[3] = stress(1,2) = 8.9;
  v[4] = stress(1,3) = -3.4;
  v[5] = stress(2,3) = 9.7;
  strain(1,2) = 0.5*v[3];
  strain(1,3) = 0.5*v[4];
  strain(2,3) = 0.5*v[5];
  tensor2<long double> tsr(3,false), tsr2(3,false);
  for (int i=1; i<=3; i++)
    for (int j=1; j<=3; j++)
      { tsr(i,j) = stress(i,j);
	tsr2(i,j) = strain(i,j);
      }

  if (detail) affiche("vector2stress", stress==abaqus::vector2stress(v) && tsr==abaqus::vector2stress(v));
  else result *= (stress==abaqus::vector2stress(v) && tsr==abaqus::vector2stress(v));

  if (detail) affiche("vector2strain", strain == abaqus::vector2strain(v) && tsr2==abaqus::vector2strain(v));
  else result *= (strain == abaqus::vector2strain(v) && tsr2==abaqus::vector2strain(v));

  bool test = true;
  long double *w;
  w = new long double [6];
  abaqus::stress2vector(stress,w);
  for (int i=0; i<6; i++)
    test *= (abs (v[i] - w[i]) < epsilon);
  long double *z;
  z = new long double [6];
  abaqus::stress2vector((symtensor2<long double>)tsr,z);
  for (int i=0; i<6; i++)
    test *= (abs (v[i] - z[i]) < epsilon);
  abaqus::stress2vector (tsr, z);
  for (int i=0; i<6; i++)
    test *= (abs (v[i] - z[i]) < epsilon);
  if (detail) affiche("stress2vector", test);
  else result *= (test);

  test = true;
  abaqus::strain2vector(strain,w);
  for (int i=0; i<6; i++)
    test *= (abs (v[i] - w[i]) < epsilon);
  abaqus::strain2vector(tsr2,z);
  for (int i=0; i<6; i++)
    test *= (abs (v[i] - z[i]) < epsilon);
  if (detail) affiche("strain2vector", test);
  else result *= (test);

  test = true;
  tensor4<long double> C(3,false);
  for (int i=1; i<=3; i++)
    for (int j=1; j<=3; j++)
      for (int k=1; k<=3; k++)
	for (int l=1; l<=3; l++)
	  C(i,j,k,l) = C(j,i,k,l) = C(i,j,l,k) = C(j,i,l,k) = 2.9*i - 0.5*j + 9*(i+3*k-l) * (j-l) * k + 459.25*(i==j)*(k==l)*(i==l);
  stress = (C || strain);
  abaqus::stress2vector(stress,v);
  abaqus::strain2vector(strain,w);
  matrix<long double> M =& abaqus::symtensor2matrix(C);
  for (int i=1; i<=6; i++)
    { long double value = 0;
      for (int j=1; j<=6; j++)
	value += M(i,j) * w[j-1];
      test *= (abs (value - v[i-1]) < epsilon);
    }
  matrix<long double> N =& gauss(M);
  for (int i=1; i<=6; i++)
    { long double value = 0;
      for (int j=1; j<=6; j++)
	value += N(i,j) * v[j-1];
      test *= (abs (value - w[i-1]) < epsilon);
    }
  if (detail) affiche("symtensor2matrix", test);
  else result *= (test);

  tensor4<long double> Cc =& abaqus::matrix2symtensor(M);
  if (detail) affiche("matrix2symtensor", C==Cc);
  else result *= (C==Cc);

  delete v;
  delete w;
  delete z;

  cout << endl;

  cout << "============================================================== \n";
  if (result) cout << green << "             abaqus conversion tools test passed" << reset;
  else cout << red << "             abaqus conversion tools test failed" << reset;
  cout << "============================================================== \n";

  return result;
}


#endif
